<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code','allow_fb')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"]; 
$allow_fb = $config_array["allow_fb"];

// Include the JS file
$js_files = array("js/pages/admin.js");

// Metadata informations of this page
$page_title = "Manage Settings";
$page_slug	= "manage-settings";

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

if($_SESSION["RANK"] == 0) {
	header("Location: home.php?action=forbidden");
	exit;	
}

$success = 0;
$error = "";

if($_POST) {
	
	if(TEST_MODE) {
		$error = "You can't update the website settings in demo mode.";
	} else {
	
		if(isset($_POST["website_name"]) && isset($_POST["website_tagline"])) {
			
			$website_name = $_POST["website_name"];
			$website_tagline = $_POST["website_tagline"];
			$ads_code = $_POST["advert_code"];
			
			if(isset($_POST["allow_fb"])) {
				$allow_fb = 1;
			} else {
				$allow_fb = 0;
			}
			
			if(strlen($website_name) < 2) {
				
				$error = "Your website name must be at least 2 characters long.";
				
			} else {
				
				$site_config = $dbh->prepare("UPDATE config SET config_value = :config_value WHERE config_name = 'website_name'");
				$site_config->bindParam(":config_value", $website_name);
				$site_config->execute();
				
				$site_config = $dbh->prepare("UPDATE config SET config_value = :config_value WHERE config_name = 'website_tagline'");
				$site_config->bindParam(":config_value", $website_tagline);
				$site_config->execute();
				
				$site_config = $dbh->prepare("UPDATE config SET config_value = :config_value WHERE config_name = 'ads_code'");
				$site_config->bindParam(":config_value", $ads_code);
				$site_config->execute();
				
				$site_config = $dbh->prepare("UPDATE config SET config_value = :config_value WHERE config_name = 'allow_fb'");
				$site_config->bindParam(":config_value", $allow_fb);
				$site_config->execute();
				
				$success = 1;
				
			}
			
		}
	
	}
	
}

$user_id = $_SESSION["USER_ID"];
	
// -- Include the header template
include("templates/headers/admin_header.php")
?>

<div class="row">

	<div class="inner-container content" id="main-content">
					
		<h3>Website Settings</h3>
		
		<div class="content-inner">
			<form action="" method="post" id="profile-form">
				<div class="admin-config">
					<?php
					if($success == 1) {	
					?>
					<div class="alert alert-success alert-center">
						Your settings have been updated.              
				    </div>
				    <?php
					}
					?>
					<legend>General Config</legend>
					<div class="row">
						<div class="col-md-6">
							<div class="form-group form-centered">
								<label>Website Name</label>
								<input value="<?php echo $website_name; ?>" type="text" autocomplete="off" class="form-control website_name" name="website_name" placeholder="Enter the Website Name" />
							</div>
						</div>
						<div class="col-md-6">
							<div class="form-group form-centered">
								<label>Website Tagline</label>
								<input value="<?php echo $website_tagline; ?>" type="text" autocomplete="off" class="form-control website_tagline" name="website_tagline" placeholder="Enter the Website Tagline" />
							</div>
						</div>
						
						<hr />
						<div class="col-md-12">
							<div class="form-group form-centered">
								<label>Ads Code</label>
								<textarea class="form-control advert_code" name="advert_code" placeholder="Paste your Ads Code"><?php echo $ads_code; ?></textarea>
							</div>
						</div>
						<hr />
						<div class="col-md-6 offset-md-4">
						<div class="form-check">
							<input type="checkbox" class="form-check-input" id="allow_fb" name="allow_fb" <?php if($allow_fb == 1) { ?>checked<?php } ?>>
							<label class="form-check-label" for="allow_fb">Enable Facebook Login</label>
						</div>
						</div>
					</div>
					
					<hr />
					
					<?php
					if($error != "") {	
					?>
					<div class="alert alert-danger alert-center">
						<?php echo $error; ?>              
				    </div>
				    <?php
					}
					?>
					<center>
						<button type="submit" class="btn btn-primary btn-edit-config">Save Config <i class="fas fa-check"></i></button>
					</center>
				</div>
				
			</form>
		
		</div>
		
	</div>		
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>